/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopMerchantProductQueryResponse.java, v 0.1 2023-05-04 11:36:24
 */
@Data
public class YopMerchantProductQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555627931864L;


    /**
     * 响应编码(示例值：NIG00000)
     *
     * (选填)
     */
    private String returnCode;

    /**
     * 响应描述(示例值：请求成功)
     *
     * (选填)
     */
    private String returnMsg;

    /**
     * 产品变更请求号(示例值：0adc579914d541f8baa3be75387846f1)
     *
     * (选填)
     */
    private String requestNo;

    /**
     * 申请单编号(示例值：CPBGLC20220113999999)
     *
     * (选填)
     */
    private String applicationNo;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 申请状态(示例值：REVIEWING(申请审核中),AUTHENTICITY_VERIFYING(真实性验证中),REVIEW_BACK(申请已驳回),AGREEMENT_SIGNING(协议待签署),BUSINESS_OPENING(业务开通中),COMPLETED(申请已完成))
     *
     * (选填)
     */
    private String applicationStatus;

    /**
     * 审核意见，申请已驳回时或者申请已完成时，回传的审核意见
     *
     * (选填)
     */
    private String auditOpinion;

    /**
     * 产品变更进度说明<br>当申请状态为AUTHENTICITY_VERIFYING(真实性验证中)时，返回的产品变更进度说明(示例值：["REMIT_AUTH"](待打款验资))
     *
     * (选填)
     */
    private String progressDescription;

}