/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopMerchantProductModifyResponse.java, v 0.1 2023-05-04 11:01:50
 */
@Data
public class YopMerchantProductModifyResponse implements Serializable {

    private static final long serialVersionUID = -2213838555745772960L;


    /**
     * 响应编码(示例值：NIG00000)
     *
     * (选填)
     */
    private String returnCode;

    /**
     * 响应描述(示例值：请求成功)
     *
     * (选填)
     */
    private String returnMsg;

    /**
     * 请求号(示例值：1231231123)
     *
     * (选填)
     */
    private String requestNo;

    /**
     * 申请单编号(示例值：TYSHRW20200713999999)
     *
     * (选填)
     */
    private String applicationNo;

    /**
     * 申请状态<br>REVIEWING:申请审核中<br>REVIEW_BACK:申请已驳回<br>AGREEMENT_SIGNING:协议待签署<br>BUSINESS_OPENING:业务开通中<br>COMPLETED:申请已完成(示例值：REVIEWING)
     *
     * (选填)
     */
    private String applicationStatus;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

}