package com.fshows.yeepay.sdk.response.merchant;

import lombok.Data;

/**
 * @author liangyuanping
 * @version MerchantRegisterQueryResponse.java, v 0.1 2023-04-19 9:58 PM
 */
@Data
public class MerchantRegisterQueryResponse {


    /**
     * 响应编码
     * 示例值：NIG00000
     */
    private String returnCode;
    /**
     * 响应描述
     * 示例值：请求成功
     */
    private String returnMsg;
    /**
     * 入网请求号
     * 示例值：0adc579914d541f8baa3be75387846f1
     */
    private String requestNo;
    /**
     * 入网请求号
     */
    private String applicationNo;
    /**
     * 商户编号
     */
    private String merchantNo;
    /**
     * 申请状态
     * 示例值：REVIEWING(申请审核中),REVIEW_BACK(申请已驳回),AGREEMENT_SIGNING(协议待签署),BUSINESS_OPENING(业务开通中),COMPLETED(申请已完成)
     */
    private String applicationStatus;
    /**
     * 审核意见，申请已驳回时或者申请已完成时，回传的审核意见
     */
    private String auditOpinion;
    /**
     * 入网进度说明
     * 当申请状态为AUTHENTICITY_VERIFYING(真实性验证中)时，返回的入网进度说明
     * 示例值：["REMIT_AUTH"](待打款验资)
     */
    private String progressDescription;

}