package com.fshows.yeepay.sdk.response.account.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author liangyuanping
 * @version YopAccountInfoListItemResponse.java, v 0.1 2023-04-20 1:50 PM
 */
@Data
public class YopAccountInfoListItemResponse {
    /**
     * 账户类型<br>SETTLE_ACCOUNT:待结算账户<br>FUND_ACCOUNT:商户资金账户 <br>MARKET_ACCOUNT:营销账户 <br>DIVIDE_ACCOUNT:待分账账户 <br>FEE_ACCOUNT:手续费账户
     *
     * (选填)
     */
    private String accountType;

    /**
     * 开户时间
     *
     * (选填)
     */
    private String createTime;

    /**
     * 余额
     *
     * (选填)
     */
    private BigDecimal balance;

    /**
     * 账户状态<br>可选项如下:<br>AVAILABLE:可用<br>FROZEN:冻结<br>FROZEN_CREDIT:冻结止收<br>FROZEN_DEBIT:冻结止付<br>CANCELLATION:销户
     *
     * (选填)
     */
    private String accountStatus;
}