/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopAccountWithdrawOrderResponse.java, v 0.1 2023-04-20 13:39:10
 */
@Data
public class YopAccountWithdrawOrderResponse implements Serializable {

    private static final long serialVersionUID = -2213838555963023216L;


    /**
     * 返回码<br>该参数代表本次请求的处理结果，UA00000为请求成功 若请求失败参看对应错误码和错误信息<br>
     *
     * (选填)
     */
    private String returnCode;

    /**
     * 返回信息
     *
     * (选填)
     */
    private String returnMsg;

    /**
     * 订单状态<br>可选项如下:<br>REQUEST_RECEIVE:请求已接收（易宝正在处理中，收到最终结果前请勿重复下单）<br>REQUEST_ACCEPT:请求已受理（易宝正在处理中，收到最终结果前请勿重复下单）<br>FAIL:失败<br>REMITING:（银行正在处理中，收到最终结果前请勿重复下单）
     *
     * (选填)
     */
    private String status;

    /**
     * 易宝提现订单号<br>易宝支付系统生成的提现订单号
     *
     * (选填)
     */
    private String orderNo;

}