/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopTradeRefundResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 申请退款
 *
 * @author
 * @version YopTradeRefundRequest.java, v 0.1 2023-04-20 11:43:08
 */
@Data
public class YopTradeRefundRequest extends YopBizRequest<YopTradeRefundResponse> {

    private static final long serialVersionUID = -2213838555940744129L;

    /**
     * 收款商户编号(示例值：10012426723)
     *
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;

    /**
     * 收款交易对应的商户收款请求号(示例值：order123456789)
     *
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    /**
     * 商户退款请求号(示例值：refundorder987654)
     *
     * (选填)
     */
    @Length(max = 64, message = "refundRequestId长度不能超过64")
    private String refundRequestId;

    /**
     * 收款交易对应的易宝收款订单号。(示例值：1001201612070000000000000565)
     *
     * (选填)
     */
    @Length(max = 32, message = "uniqueOrderNo长度不能超过32")
    private String uniqueOrderNo;

    /**
     * 退款申请金额<br>单位：元，两位小数，最低0.01，退款金额不能大于原订单金额，多次退款时，累计退款金额不能超过原订单金额(示例值：88.88)
     *
     * (选填)
     */
    private String refundAmount;

    /**
     * 退款原因(示例值：用户申请退货并退款)
     *
     * (选填)
     */
    @Length(max = 80, message = "description长度不能超过80")
    private String description;

    /**
     * 对账备注<br>商户自定义参数，会展示在交易对账单中(示例值：退款)
     *
     * (选填)
     */
    @Length(max = 200, message = "memo长度不能超过200")
    private String memo;

    /**
     * 退款资金来源<br>FUND_ACCOUNT：资金账户余额<br>不传则默认使用未结算资金退款,如未结算资金不足则使用资金账户余额退款，无资金账户则会报错未找到账户(示例值：FUND_ACCOUNT)
     *
     * (选填)
     */
    private String refundAccountType;

    /**
     * 退款结果回调url<br>接收退款结果通知地址，不传则不通知 回调参数请参考：<a href="#anchor7">退款结果通知</a>
     *
     * (选填)
     */
    @Length(max = 200, message = "notifyUrl长度不能超过200")
    private String notifyUrl;

    /**
     * 易宝优惠退款信息
     *
     * (选填)
     */
    private String ypPromotionRefundInfo;

    @Override
    public Class<YopTradeRefundResponse> getResponseClass() {
        return YopTradeRefundResponse.class;
    }
}