/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopTradeOrderCloseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopTradeOrderCloseRequest.java, v 0.1 2023-04-23 20:01:43
 */
@Data
public class YopTradeOrderCloseRequest extends YopBizRequest<YopTradeOrderCloseResponse> {

    private static final long serialVersionUID = -2213838555885198714L;


    /**
     * 商户收款请求号。可包含字母、数字、下划线；需保证在商户端不重复。合单收款场景中，此参数为合单收款请求号
     *
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    /**
     * 易宝收款订单号,合单收款场景中是主单易宝收款订单号。
     *
     * (选填)
     */
    @Length(max = 32, message = "uniqueOrderNo长度不能超过32")
    private String uniqueOrderNo;

    /**
     * 商户编号<br>收款商户商编，单笔收款必传；合单收款场景中不用上送。
     *
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;


    @Override
    public Class<YopTradeOrderCloseResponse> getResponseClass() {
        return YopTradeOrderCloseResponse.class;
    }
}