/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopTradeDayDownloadResponse;
import lombok.Data;

/**
 * 交易日对账下载
 *
 * @author
 * @version YopTradeDayDownloadRequest.java, v 0.1 2023-04-20 13:57:37
 */
@Data
public class YopTradeDayDownloadRequest extends YopBizRequest<YopTradeDayDownloadResponse> {

    private static final long serialVersionUID = -2213838555572335980L;


    /**
     * 标准商户:标准商户编号<br>平台商:平台商商户编号, 文件包含平台商及平台商下所有入驻商户的交易信息
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 日期<br>eg:2017-09-09
     *
     * (选填)
     */
    private String dayString;

    /**
     * 数据类型：merchant:商户对账文件platform:服务商对账文件
     *
     * (选填)
     */
    private String dataType;

    @Override
    public Class<YopTradeDayDownloadResponse> getResponseClass() {
        return YopTradeDayDownloadResponse.class;
    }
}