/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.order;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.order.YopOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 订单查询
 * @author
 * @version YopOrderQueryRequest.java, v 0.1 2023-04-20 10:13:00
 */
@Data
public class YopOrderQueryRequest extends YopBizRequest<YopOrderQueryResponse> {

    private static final long serialVersionUID = -2213838555614315283L;

    /**
     * 收款商户编号
     * <p>
     * (选填)
     */
    @Length(max = 11, message = "merchantNo长度不能超过11")
    private String merchantNo;

    /**
     * 交易下单传入的商户收款请求号。<br>(合单收款场景请传入子单的商户收款请求号)
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "orderId长度不能超过64")
    private String orderId;

    @Override
    public Class<YopOrderQueryResponse> getResponseClass() {
        return YopOrderQueryResponse.class;
    }
}