/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.merchant;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.merchant.YopWechatConfigAddResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopWechatConfigAddReqeust.java, v 0.1 2023-05-06 17:14:49
 */
@Data
public class YopWechatConfigAddReqeust extends YopBizRequest<YopWechatConfigAddResponse> {

    private static final long serialVersionUID = -2213838555134797724L;


    /**
     * 发起方商户编号
     *
     * (选填)
     */
    private String parentMerchantNo;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 支付授权目录列表(示例值：["http://www.yeepay.com/","http://www.yeepay.com/"])
     *
     * (选填)
     */
    private String tradeAuthDirList;

    /**
     * 支付appId目录列表<br>JSON字符串；<br>appId 支付appId<br>appSecret 支付appSecret<br>appIdType appId类型（OFFICIAL_ACCOUNT:公众号；MINI_PROGRAM:小程序）<br>subscribeAppId 推荐关注appId(示例值：[{"appId":"appId","appSecret":"appSecret","appIdType":"OFFICIAL_ACCOUNT","subscribeAppId":"subscribeAppId"},{"appId":"appId","appSecret":"appSecret","appIdType":"MINI_PROGRAM","subscribeAppId":"subscribeAppId"}])
     *
     * (选填)
     */
    private String appIdList;

    @Override
    public Class<YopWechatConfigAddResponse> getResponseClass() {
        return YopWechatConfigAddResponse.class;
    }
}