/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.account;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.account.YopAccountWithdrawOrderResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 * 提现-下单
 * @author
 * @version YopAccountWithdrawOrderRequest.java, v 0.1 2023-04-20 13:39:10
 */
@Data
public class YopAccountWithdrawOrderRequest extends YopBizRequest<YopAccountWithdrawOrderResponse> {

    private static final long serialVersionUID = -2213838555446747498L;

    /**
     * 商户请求号<br>由商户自定义生成(示例值：WITHDRAW20200327103027)
     *
     * (选填)
     */
    @Length(max = 32, message = "requestNo长度不能超过32")
    private String requestNo;

    /**
     * 商户编号<br>易宝支付分配的的商户唯一标识(示例值：100400612345)
     *
     * (选填)
     */
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 提现卡ID<br>添加提现账户时易宝生成的提现卡ID，与提现卡卡号至少填写一个(示例值：11103)
     *
     * (选填)
     */
    @Length(max = 32, message = "bankCardId长度不能超过32")
    private String bankCardId;

    /**
     * 提现账号<br>与提现卡ID至少填写一个(示例值：6212260200019388841)
     *
     * (选填)
     */
    @Length(max = 32, message = "bankAccountNo长度不能超过32")
    private String bankAccountNo;

    /**
     * 到账类型<br>可选项如下:<br>REAL_TIME:实时<br>TWO_HOUR:2小时到账<br>NEXT_DAY:次日到账（无特殊情况资金于次日上午7点左右到提现银行账户中）(示例值：REAL_TIME)
     *
     * (选填)
     */
    private String receiveType;

    /**
     * 提现金额，单位：元（RMB）(示例值：1.00)
     *
     * (选填)
     */
    private BigDecimal orderAmount;

    /**
     * 回调通知地址<br>商户通知地址,不传则不通知<br>回调内容请参看：<br><a href="#anchor7">结果通知</a>(示例值：www.baidu.com)
     *
     * (选填)
     */
    @Length(max = 128, message = "notifyUrl长度不能超过128")
    private String notifyUrl;

    /**
     * 银行附言<br>展示在收款银行系统中的附言，由数字、字母、汉字组成（最终附言内容以银行实际账单为准）。(示例值：XXX平台提现)
     *
     * (选填)
     */
    @Length(max = 128, message = "remark长度不能超过128")
    private String remark;

    /**
     * 终端类型<br>可选项如下:<br>PC:电脑<br>PHONE:手机<br>PAD:平板<br>NFC:可穿戴设备<br>DTV:数字电视<br>MPOS:条码支付受理终端<br>OTHER:其他(示例值：PC)
     *
     * (选填)
     */
    private String terminalType;

    /**
     * 手续费收取方式<br>可选项如下:<br>OUTSIDE:外扣<br>INSIDE:内扣
     *
     * (选填)
     */
    private String feeDeductType;

    @Override
    public Class<YopAccountWithdrawOrderResponse> getResponseClass() {
        return YopAccountWithdrawOrderResponse.class;
    }
}