/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.account;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.account.YopAccountAccountInfosQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 *
 * 全部账户余额查询
 * @author
 * @version YopAccountAccountInfosQueryRequest.java, v 0.1 2023-04-20 13:48:16
 */
@Data
public class YopAccountAccountInfosQueryRequest extends YopBizRequest<YopAccountAccountInfosQueryResponse> {

    private static final long serialVersionUID = -2213838555340711143L;


    /**
     * 商户编号
     *
     * (选填)
     */
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    @Override
    public Class<YopAccountAccountInfosQueryResponse> getResponseClass() {
        return YopAccountAccountInfosQueryResponse.class;
    }
}