/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author youmingming
 * @version YopBizRequest.java, v 0.1 2022-02-09 下午5:12 youmingming
 */
@Data
public abstract class YopBizRequest<R> implements Serializable {

    private static final long serialVersionUID = 1353569682550857298L;

    /**
     * 发起方商户编号。*标准商户收付款方案中此参数与收款商户编号一致；*平台商户收付款方案中此参数为平台商商户编号；*服务商解决方案中，①标准商户收款时，该参数为标准商户商编 ②平台商收款或平台商入驻商户收款时，该参数为平台商商编。 如果商户使用先下单再支付模式，已传入token，则本字段可以不传值，否则必须传值(示例值：10040012345)
     *
     * (选填)
     */
    private String parentMerchantNo;


    @JSONField(serialize = false)
    private Class<R> responseClass;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    public abstract Class<R> getResponseClass();
}