package com.fshows.yeepay.sdk.enums;

import com.fshows.yeepay.sdk.client.impl.YopApiDefinition;
import com.fshows.yeepay.sdk.request.account.YopAccountAccountInfosQueryRequest;
import com.fshows.yeepay.sdk.request.account.YopAccountWithdrawOrderQueryRequest;
import com.fshows.yeepay.sdk.request.account.YopAccountWithdrawOrderRequest;
import com.fshows.yeepay.sdk.request.merchant.*;
import com.fshows.yeepay.sdk.request.order.*;
import com.fshows.yeepay.sdk.response.account.YopAccountAccountInfosQueryResponse;
import com.fshows.yeepay.sdk.response.account.YopAccountWithdrawOrderQueryResponse;
import com.fshows.yeepay.sdk.response.account.YopAccountWithdrawOrderResponse;
import com.fshows.yeepay.sdk.response.merchant.*;
import com.fshows.yeepay.sdk.response.order.*;
import com.fshows.yeepay.sdk.util.StringPool;

/**
 * @author liangyuanping
 * @version YopApiEnum.java, v 0.1 2023-04-19 10:01 PM
 */
public enum YopApiEnum implements YopApiDefinition {

    QUERY_REGISTER(
            "商户入网进度查询接口",
            "/rest/v2.0/mer/register/query",
            StringPool.GET,
            MerchantRegisterQueryRequest.class,
            MerchantRegisterQueryResponse.class),

    AGGPAY_PRE_PAY(
            "聚合支付统一下单",
            "/rest/v1.0/aggpay/pre-pay",
            StringPool.POST,
            YopAggpayPrepayRequest.class,
            YopAggpayPrepayResponse.class),

    AGGPAY_PAY(
            "付款码支付",
            "/rest/v1.0/aggpay/pay",
            StringPool.POST,
            YopAggpayPayRequest.class,
            YopAggpayPayResponse.class),

    QUERY_ORDER(
            "查询订单",
            "/rest/v1.0/trade/order/query",
            StringPool.GET,
            YopOrderQueryRequest.class,
            YopOrderQueryResponse.class),

    TRADE_REFUND(
            "申请退款",
            "/rest/v1.0/trade/refund",
            StringPool.POST,
            YopTradeRefundRequest.class,
            YopTradeRefundResponse.class),

    QUERY_REFUND(
            "查询退款",
            "/rest/v1.0/trade/refund/query",
            StringPool.GET,
            YopTradeRefundQueryRequest.class,
            YopTradeRefundQueryResponse.class),

    ACCOUNT_WITHDRAW_ORDER(
            "提现-下单",
            "/rest/v1.0/account/withdraw/order",
            StringPool.POST,
            YopAccountWithdrawOrderRequest.class,
            YopAccountWithdrawOrderResponse.class),

    QUERY_ACCOUNT_WITHDRAW_ORDER(
            "提现-查询",
            "/rest/v1.0/account/withdraw/system/query",
            StringPool.GET,
            YopAccountWithdrawOrderQueryRequest.class,
            YopAccountWithdrawOrderQueryResponse.class),

    QUERY_ACCOUNT_ACCOUNTINFOS(
            "全部账户余额查询",
            "/rest/v1.0/account/accountinfos/query",
            StringPool.GET,
            YopAccountAccountInfosQueryRequest.class,
            YopAccountAccountInfosQueryResponse.class),

    TRADE_DAY_DOWNLOAD(
            "交易日对账下载",
                    "/yos/v1.0/std/bill/tradedaydownload",
            StringPool.GET,
            YopTradeDayDownloadRequest.class,
            YopTradeDayDownloadResponse.class),

    TRADE_ORDER_CLOSE(
            "关闭订单",
                    "/rest/v1.0/trade/order/close",
            StringPool.POST,
            YopTradeOrderCloseRequest.class,
            YopTradeOrderCloseResponse.class),

    MERCHANT_PRODUCT_MODIFY(
            "商户产品变更",
                    "/rest/v2.0/mer/product/fee/modify",
            StringPool.POST,
            YopMerchantProductModifyRequest.class,
            YopMerchantProductModifyResponse.class),

    MERCHANT_PRODUCT_MODIFY_QUERY(
            "商户产品变更进度查询接口",
            "/rest/v2.0/mer/product/modify/query",
            StringPool.GET,
            YopMerchantProductQueryRequest.class,
            YopMerchantProductQueryResponse.class),

    WECHAT_CONFIG_ADD(
            "公众号配置接口",
                    "/rest/v2.0/aggpay/wechat-config/add",
            StringPool.POST,
            YopWechatConfigAddReqeust.class,
            YopWechatConfigAddResponse.class),

    WECHAT_CONFIG_QUERY(
            "公众号配置查询接口",
                    "/rest/v2.0/aggpay/wechat-config/query",
            StringPool.GET,
            YopWechatConfigQueryReqeust.class,
            YopWechatConfigQueryResponse.class);

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口
     */
    private String value;
    /**
     * 接口请求类型
     */
    private String methodType;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    YopApiEnum(String name, String value, String methodType, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.methodType = methodType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getMethod() {
        return value;
    }

    @Override
    public String getMethodType() {
        return methodType;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}