/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.sdk.client.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.yeepay.sdk.client.YopBaseClient;
import com.fshows.yeepay.sdk.client.impl.YopApiDefinition;
import com.fshows.yeepay.sdk.exception.YopPayException;
import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.YopBaseResponse;
import com.fshows.yeepay.sdk.support.CustomSdkConfigProvider;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.client.YopRsaClient;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProviderRegistry;
import com.yeepay.g3.sdk.yop.error.YopError;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopBaseClientImpl
implements YopBaseClient {
    private static final Logger log = LoggerFactory.getLogger(YopBaseClientImpl.class);
    private static final String SUCCESS = "SUCCESS";
    private String appId;
    private String fbPrivateKey;
    private String yopPublicKey;
    private String prefixUrl;

    public YopBaseClientImpl(String appId, String fbPrivateKey, String yopPublicKey, String prefixUrl) {
        this.appId = appId;
        this.fbPrivateKey = fbPrivateKey;
        this.yopPublicKey = yopPublicKey;
        this.prefixUrl = prefixUrl;
        CustomSdkConfigProvider configProvider = new CustomSdkConfigProvider(this.prefixUrl, this.yopPublicKey, this.appId);
        AppSdkConfigProviderRegistry.registerCustomProvider((AppSdkConfigProvider)configProvider);
    }

    @Override
    public <R> YopBaseResponse<R> execute(YopBizRequest<R> request, YopApiDefinition definition) throws YopPayException {
        long startTime = System.currentTimeMillis();
        try {
            YopRequest yopRequest = new YopRequest(this.appId, this.fbPrivateKey);
            this.populateParam(request, yopRequest);
            log.info("\u3010yeepay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={},method={},request={}", new Object[]{this.prefixUrl, definition.getMethod(), yopRequest.getParams()});
            YopResponse yopResponse = "POST".equals(definition.getMethodType()) ? YopRsaClient.post((String)definition.getMethod(), (YopRequest)yopRequest) : YopRsaClient.get((String)definition.getMethod(), (YopRequest)yopRequest);
            log.info("\u3010yeepay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},method={},request={},response={},cost={}", new Object[]{this.prefixUrl, definition.getMethod(), yopRequest.getParams(), yopResponse, System.currentTimeMillis() - startTime});
            if (!SUCCESS.equals(yopResponse.getState())) {
                YopError yopError = yopResponse.getError();
                throw new YopPayException(MessageFormat.format("[{0}]{1}", yopError.getCode(), yopError.getSubMessage()));
            }
            return this.parseResponse(request, yopResponse);
        }
        catch (Exception ex) {
            log.error("\u3010yeepay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},method={},request={},ex={},cost={}", new Object[]{this.prefixUrl, definition.getMethod(), request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new YopPayException(ex.getMessage());
        }
    }

    private <R> void populateParam(YopBizRequest<R> request, YopRequest yopRequest) {
        String jsonString = JSON.toJSONString(request);
        Map map = (Map)JSON.parseObject((String)jsonString, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            yopRequest.addParam((String)entry.getKey(), entry.getValue());
        }
    }

    private <R> YopBaseResponse<R> parseResponse(YopBizRequest<R> request, YopResponse yopResponse) throws YopPayException {
        if (ObjectUtil.isNull((Object)yopResponse.getResult())) {
            throw new YopPayException("\u6613\u5b9dSDK\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
        }
        String jsonString = JSON.toJSONString((Object)yopResponse.getResult());
        JSONObject jsonObject = JSON.parseObject((String)jsonString);
        YopBaseResponse<Object> response = new YopBaseResponse<Object>();
        response.setErrorCode(jsonObject.getString("code"));
        response.setErrorMessage(jsonObject.getString("message"));
        response.setReturnValue(jsonObject.toJavaObject(request.getResponseClass()));
        return response;
    }
}

