/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.xft.sdk.client.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.xft.sdk.client.XftBaseClient;
import com.fshows.xft.sdk.client.impl.XftApiDefinition;
import com.fshows.xft.sdk.enums.XftApiEnum;
import com.fshows.xft.sdk.exception.XftException;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.XftBaseResponse;
import com.fshows.xft.sdk.util.SignUtil;
import com.fshows.xft.sdk.util.ValidateUtil;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XftBaseClientImpl
implements XftBaseClient {
    private static final Logger log = LoggerFactory.getLogger(XftBaseClientImpl.class);
    private final String appId;
    private final String signType;
    private final String key;
    private static final SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public XftBaseClientImpl(String appId, String signType, String key) {
        this.appId = appId;
        this.signType = signType;
        this.key = key;
    }

    @Override
    public <R> XftBaseResponse<R> execute(XftBizRequest<R> request, XftApiDefinition xftApiDefinition, String url) throws XftException {
        return this.execute(request, xftApiDefinition, url, this.appId);
    }

    @Override
    public <R> XftBaseResponse<R> execute(XftBizRequest<R> request, XftApiDefinition definition, String postUrl, String subAppId) throws XftException {
        String method = definition.getMethod();
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        String url = postUrl + method;
        try {
            Map<String, String> requestData = this.getRequestData(request, (String)StringUtils.defaultIfBlank((CharSequence)subAppId, (CharSequence)this.appId));
            log.info("\u3010xft-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={},request={}", (Object)url, requestData);
            String xftResponse = HttpUtil.post((String)url, (String)JSONObject.toJSONString(requestData));
            log.info("\u3010xft-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},response={},cost={}", new Object[]{url, requestData, xftResponse, System.currentTimeMillis() - startTime});
            return this.parseResponse(xftResponse, request);
        }
        catch (Exception ex) {
            log.error("\u3010xft-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new XftException(ex.getMessage());
        }
    }

    private <R> XftBaseResponse<R> parseResponse(String result, XftBizRequest<R> request) {
        JSONObject jsonObject = JSON.parseObject((String)result);
        XftBaseResponse<Object> response = new XftBaseResponse<Object>();
        response.setCode(jsonObject.getString("code"));
        response.setMessage(jsonObject.getString("message"));
        response.setResult((Boolean)jsonObject.get((Object)"result"));
        response.setData(JSONObject.parseObject((String)jsonObject.getString("data"), request.getResponseClass()));
        return response;
    }

    private <R> Map<String, String> getRequestData(XftBizRequest<R> request, String appId) throws XftException {
        TreeMap<String, String> parameterMap = SignUtil.getParameterMap(request);
        parameterMap.put("app_id", appId);
        parameterMap.put("sign_type", "MD5");
        String sign = SignUtil.generateSign(parameterMap, this.key);
        parameterMap.put("sign", sign);
        return parameterMap;
    }

    private <R> void validateParam(XftBizRequest<R> request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.key)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == XftApiEnum.getByValue(method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    static {
        XftBaseClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

