/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.xft.sdk.util;

import com.fshows.xft.sdk.util.ValidateResult;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidateUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> ValidateResult validate(T object, Class<?> ... classes) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setResult(true);
        Set constraintViolations = VALIDATOR.validate(object, (Class[])classes);
        ConstraintViolation constraintViolation = (ConstraintViolation)Iterables.getFirst((Iterable)constraintViolations, null);
        if (constraintViolation != null) {
            validateResult.setResult(false);
            validateResult.setParamName(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, constraintViolation.getPropertyPath().toString()));
            validateResult.setMsg(constraintViolation.getMessage());
        }
        return validateResult;
    }

    public static <T> void validateWithThrow(T request, Class<?> ... classes) {
        ValidateResult validate = ValidateUtil.validate(request, classes);
        if (!validate.isResult()) {
            throw new IllegalArgumentException(MessageFormat.format("\u9519\u8bef\u53c2\u6570\uff0cparam={0}\uff0cmsg={1}", validate.getParamName(), validate.getMsg()));
        }
    }
}

