/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.xft.sdk.enums;

import com.fshows.xft.sdk.client.impl.XftApiDefinition;
import com.fshows.xft.sdk.request.bill.SettleBillAgentDownloadQueryRequest;
import com.fshows.xft.sdk.request.merchant.MerchantSignInAddAppIdRequest;
import com.fshows.xft.sdk.request.merchant.MerchantSignInAddAuthRequest;
import com.fshows.xft.sdk.request.merchant.MerchantSignInQueryRequest;
import com.fshows.xft.sdk.request.trade.UnifyChargePayRequest;
import com.fshows.xft.sdk.request.trade.UnifyChargeQueryRequest;
import com.fshows.xft.sdk.request.trade.UnifyChargeRefundRequest;
import com.fshows.xft.sdk.response.bill.SettleBillAgentDownloadQueryResponse;
import com.fshows.xft.sdk.response.merchant.MerchantSignInAddAppIdResponse;
import com.fshows.xft.sdk.response.merchant.MerchantSignInAddAuthResponse;
import com.fshows.xft.sdk.response.merchant.MerchantSignInQueryResponse;
import com.fshows.xft.sdk.response.trade.UnifyChargePayResponse;
import com.fshows.xft.sdk.response.trade.UnifyChargeQueryResponse;
import com.fshows.xft.sdk.response.trade.UnifyChargeRefundResponse;
import org.apache.commons.lang3.StringUtils;

public enum XftApiEnum implements XftApiDefinition
{
    SIGNIN_ADD_AUTH("\u6dfb\u52a0\u6388\u6743\u76ee\u5f55", "/merchant/signin/add/auth", MerchantSignInAddAuthRequest.class, MerchantSignInAddAuthResponse.class),
    SIGNIN_ADD_APPID("\u6dfb\u52a0APPID", "/merchant/signin/add/appid", MerchantSignInAddAppIdRequest.class, MerchantSignInAddAppIdResponse.class),
    SIGNIN_QUERY("\u8fdb\u4ef6\u67e5\u8be2\u63a5\u53e3", "/merchant/signin/query", MerchantSignInQueryRequest.class, MerchantSignInQueryResponse.class),
    TRANSACTION_UNIFY_CHARGE_PAY("\u652f\u4ed8\u63a5\u53e3", "/transaction/unify/charge/pay", UnifyChargePayRequest.class, UnifyChargePayResponse.class),
    TRANSACTION_UNIFY_CHARGE_QUERY("\u8ba2\u5355\u67e5\u8be2", "/transaction/unify/charge/query", UnifyChargeQueryRequest.class, UnifyChargeQueryResponse.class),
    TRANSACTION_UNIFY_CHARGE_REFUND("\u7533\u8bf7\u9000\u6b3e", "/transaction/unify/charge/refund", UnifyChargeRefundRequest.class, UnifyChargeRefundResponse.class),
    SETTLE_BILL_AGENT_DOWNLOAD_QUERY("\u4e0b\u8f7d\u5bf9\u8d26", "/settle/bill/agent/download/query", SettleBillAgentDownloadQueryRequest.class, SettleBillAgentDownloadQueryResponse.class);

    private final String name;
    private final String value;
    private final Class requestClass;
    private final Class responseClass;

    private XftApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static XftApiEnum getByValue(String value) {
        XftApiEnum[] valueList;
        for (XftApiEnum v : valueList = XftApiEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getMethod(), (CharSequence)value)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String getMethod() {
        return this.value;
    }

    @Override
    public Class getRequestClass() {
        return this.requestClass;
    }

    @Override
    public Class getResponseClass() {
        return this.responseClass;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

