/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.response.XftResponse;
import lombok.Data;


/**
 * @author zhangling
 * @version XftUnifyChargeRefundResponse.java, v 0.1 2023-08-25 17:08 zhangling
 */
@Data
public class XftUnifyChargeRefundResponse extends XftResponse {
    private static final long serialVersionUID = 2119115922198052994L;
    /**
     * 商户订单号（原订单号）
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 退款金额，单位:分
     */
    @JSONField(name = "refund_amount")
    private Integer refundAmount;
    /**
     * 商户订单号（退款订单号）
     */
    @JSONField(name = "out_refund_no")
    private String outRefundNo;
    /**
     * 交易状态
     */
    private String state;
    /**
     * 退款第三方流水号
     */
    @JSONField(name = "third_trade_no")
    private String thirdTradeNo;
    /**
     * 退款微信支付宝订单号
     */
    @JSONField(name = "channel_trade_no")
    private String channelTradeNo;
}