/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.response.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.response.XftResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangling
 * @version XftMerchantSignInAddAuthResponse.java, v 0.1 2023-08-25 16:34 zhangling
 */
@Data
public class XftMerchantSignInAddAuthResponse extends XftResponse {
    private static final long serialVersionUID = 9161394066058641798L;
    /**
     * 商户编号
     */
    @JSONField(name = "merchant_code")
    private String merchantCode;
    /**
     * 是否成功 1：成功 2：失败
     */
    private String state;
    /**
     * 请求标识，请求时传了值则有值，否则为空
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
}