/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.trade.XftUnifyChargeRefundResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhangling
 * @version XftUnifyChargeRefundRequest.java, v 0.1 2023-08-25 17:07 zhangling
 */
@Data
public class XftUnifyChargeRefundRequest extends XftBizRequest<XftUnifyChargeRefundResponse> {
    private static final long serialVersionUID = -6772126826909335702L;

    /**
     * 商户订单号（原交易订单号）
     */
    @NotBlank
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 第三方支付流水号
     */
    @JSONField(name = "third_trade_no")
    private String thirdTradeNo;
    /**
     * 商户订单号（退款订单号）
     */
    @NotBlank
    @JSONField(name = "out_refund_no")
    private String outRefundNo;
    /**
     * 交易金额，单位:分
     */
    @NotNull
    @JSONField(name = "total_amount")
    private Integer totalAmount;
    /**
     * 退款金额，单位:分
     */
    @NotNull
    @JSONField(name = "refund_amount")
    private Integer refundAmount;
    /**
     * 商品标题
     */
    @NotBlank
    private String subject;
    /**
     * 商品描述信息
     */
    @NotBlank
    private String body;
    /**
     * 订单附加说明
     */
    @NotBlank
    private String description;
    /**
     * 预留字段
     */
    private String extra;
    /**
     * 通知地址，预留字段
     */
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftUnifyChargeRefundResponse> getResponseClass() {
        return XftUnifyChargeRefundResponse.class;
    }
}