/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version XftMerchantSignInAddAuthRequest.java, v 0.1 2023-08-25 16:34 zhangling
 */
@Data
public class XftMerchantSignInQueryRequest extends XftBizRequest<XftMerchantSignInQueryResponse> {
    private static final long serialVersionUID = -4728848726928441866L;

    /**
     * 所属渠道编号，由系统分配
     */
    @NotBlank
    @JSONField(name = "agent_code")
    private String agentCode;
    /**
     * 请求标识，确保唯一
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 商户编号
     */
    @NotBlank
    @JSONField(name = "merchant_code")
    private String merchantCode;
    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftMerchantSignInQueryResponse> getResponseClass() {
        return XftMerchantSignInQueryResponse.class;
    }
}