/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInAddAuthResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version XftMerchantSignInAddAuthRequest.java, v 0.1 2023-08-25 16:34 zhangling
 */
@Data
public class XftMerchantSignInAddAuthRequest extends XftBizRequest<XftMerchantSignInAddAuthResponse> {
    private static final long serialVersionUID = -8490757232196982771L;

    /**
     * 请求标识，确保唯一
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 商户编号
     */
    @NotBlank
    @JSONField(name = "merchant_code")
    private String merchantCode;
    /**
     * 支付授权目录
     */
    @NotBlank
    @JSONField(name = "auth_dir")
    private String authDir;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftMerchantSignInAddAuthResponse> getResponseClass() {
        return XftMerchantSignInAddAuthResponse.class;
    }
}