/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInAddAppIdResponse;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInAddAuthResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version XftMerchantSignInAddAuthRequest.java, v 0.1 2023-08-25 16:34 zhangling
 */
@Data
public class XftMerchantSignInAddAppIdRequest extends XftBizRequest<XftMerchantSignInAddAppIdResponse> {
    private static final long serialVersionUID = -2063145346995205843L;
    /**
     * 请求标识，确保唯一
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 商户编号
     */
    @NotBlank
    @JSONField(name = "merchant_code")
    private String merchantCode;
    /**
     * 微信appId
     */
    @NotBlank
    @JSONField(name = "wx_app_id")
    private String wxAppId;
    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftMerchantSignInAddAppIdResponse> getResponseClass() {
        return XftMerchantSignInAddAppIdResponse.class;
    }
}