package com.fshows.xft.sdk.enums;

import com.fshows.xft.sdk.client.impl.XftApiDefinition;
import com.fshows.xft.sdk.request.bill.XftSettleBillDownloadQueryRequest;
import com.fshows.xft.sdk.request.merchant.XftMerchantSignInAddAppIdRequest;
import com.fshows.xft.sdk.request.merchant.XftMerchantSignInAddAuthRequest;
import com.fshows.xft.sdk.request.merchant.XftMerchantSignInQueryRequest;
import com.fshows.xft.sdk.request.trade.XftUnifyChargePayRequest;
import com.fshows.xft.sdk.request.trade.XftUnifyChargeQueryRequest;
import com.fshows.xft.sdk.request.trade.XftUnifyChargeRefundRequest;
import com.fshows.xft.sdk.response.bill.XftSettleBillDownloadQueryResponse;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInAddAppIdResponse;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInAddAuthResponse;
import com.fshows.xft.sdk.response.merchant.XftMerchantSignInQueryResponse;
import com.fshows.xft.sdk.response.trade.XftUnifyChargePayResponse;
import com.fshows.xft.sdk.response.trade.XftUnifyChargeQueryResponse;
import com.fshows.xft.sdk.response.trade.XftUnifyChargeRefundResponse;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author liangyuanping
 * @version XftApiEnum.java, v 0.1 2023-04-19 10:01 PM
 */
@Getter
public enum XftApiEnum implements XftApiDefinition {

    /************** 商户进件相关 ************/
    SIGNIN_ADD_AUTH("添加授权目录",
            "/merchant/signin/add/auth",
            XftMerchantSignInAddAuthRequest.class,
            XftMerchantSignInAddAuthResponse.class),

    SIGNIN_ADD_APPID("添加APPID",
            "/merchant/signin/add/appid",
            XftMerchantSignInAddAppIdRequest.class,
            XftMerchantSignInAddAppIdResponse.class),

    SIGNIN_QUERY("进件查询接口",
            "/merchant/signin/query",
            XftMerchantSignInQueryRequest.class,
            XftMerchantSignInQueryResponse.class),

    /************** 支付相关 ************/

    TRANSACTION_UNIFY_CHARGE_PAY("支付接口",
            "/transaction/unify/charge/pay",
            XftUnifyChargePayRequest.class,
            XftUnifyChargePayResponse.class),

    TRANSACTION_UNIFY_CHARGE_QUERY("订单查询",
            "/transaction/unify/charge/query",
            XftUnifyChargeQueryRequest.class,
            XftUnifyChargeQueryResponse.class),

    TRANSACTION_UNIFY_CHARGE_REFUND("申请退款",
            "/transaction/unify/charge/refund",
            XftUnifyChargeRefundRequest.class,
            XftUnifyChargeRefundResponse.class),

    SETTLE_BILL_DOWNLOAD_QUERY("下载对账",
            "/settle/bill/download/query",
            XftSettleBillDownloadQueryRequest.class,
            XftSettleBillDownloadQueryResponse.class)
    ;

    /**
     * 接口名称
     */
    private final String name;
    /**
     * 接口
     */
    private final String value;
    /**
     * 请求参数类型
     */
    private final Class requestClass;
    /**
     * 响应参数类型
     */
    private final Class responseClass;

    XftApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static XftApiEnum getByValue(String value) {
        XftApiEnum[] valueList = XftApiEnum.values();
        for (XftApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getMethod(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}