/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.xft.sdk.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.xft.sdk.exception.XftPayException;
import com.fshows.xft.sdk.util.StreamUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class SignUtil {
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins != null && !StringUtils.isEmpty((CharSequence)algorithm)) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = StreamUtil.readText(ins).getBytes();
            encodedKey = Base64.getDecoder().decode(encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        return null;
    }

    private static String getContent(Map<String, String> param) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        int index = 0;
        for (String key : keys) {
            String value = param.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    private static String getVerifiedContent(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key) == null ? "" : params.get(key).toString();
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String sign(Map<String, String> data, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            String content = SignUtil.getContent(data);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String sign(String content, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Boolean verifySign(Map<String, Object> data, String signType, String sign, String publicKey) {
        try {
            String content = SignUtil.getVerifiedContent(data);
            PublicKey pubKey = SignUtil.getPublicKeyFromX509(signType, new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes("utf-8"));
            return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> TreeMap<String, String> getParameterMap(T t) throws XftPayException {
        List fieldList = FieldUtils.getAllFieldsList(t.getClass());
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Field field : fieldList) {
            field.setAccessible(true);
            try {
                String fieldName;
                Object o = field.get(t);
                if (o == null || "serialVersionUID".equalsIgnoreCase(fieldName = field.getName())) continue;
                paramMap.put(StrUtil.toUnderlineCase((CharSequence)fieldName), o.toString());
            }
            catch (IllegalAccessException e) {
                throw new XftPayException("");
            }
        }
        return paramMap;
    }

    public static TreeMap<String, String> getParameterMap(JSONObject jsonObject) {
        Map map = jsonObject.getInnerMap();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            paramMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return paramMap;
    }

    public static String generateSign(TreeMap<String, String> params, String key) {
        List paramKeyBySort = params.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.toList());
        Map<String, String> resultMap = SignUtil.mapKey2LowerCase(params);
        StringBuilder paramStr = new StringBuilder();
        for (String paramKey : paramKeyBySort) {
            paramStr.append(paramKey).append("=").append(resultMap.get(paramKey)).append("&");
        }
        paramStr.append("key=").append(key);
        return SecureUtil.md5((String)paramStr.toString()).toUpperCase();
    }

    private static Map<String, String> mapKey2LowerCase(Map<String, String> formParam) {
        HashMap resultMap = Maps.newHashMap();
        for (String key : formParam.keySet()) {
            resultMap.put(key.toLowerCase(), formParam.get(key));
        }
        return resultMap;
    }
}

