/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.response.trade;

import com.fshows.xft.sdk.response.XftResponse;
import lombok.Data;

/**
 * @author zhangling
 * @version XftUnifyChargeQueryResponse.java, v 0.1 2023-08-25 17:04 zhangling
 */
@Data
public class XftUnifyChargeQueryResponse extends XftResponse {
    private static final long serialVersionUID = -4939981880854539569L;

    /**
     * 商户订单号
     */
    private String outTradeNo;
    /**
     * 订单金额，单位：分
     */
    private Integer amount;
    /**
     * 交易状态
     */
    private String state;
    /**
     * 付款人标识
     */
    private String payerId;
    /**
     * 订单标题
     */
    private String subject;
    /**
     * 商品描述信息
     */
    private String body;
    /**
     * 订单附加说明
     */
    private String description;
    /**
     * 支付渠道,详细参考 支付渠道 channel 属性值
     */
    private String channel;
    /**
     * 支付产品,详细参考 支付产品 product 属性值
     */
    private String product;
    /**
     * 门店编号
     */
    private String storeCode;
    /**
     * 操作员 id
     */
    private String operatorId;
    /**
     * 第三方流水号
     */
    private String thirdTradeNo;
    /**
     * 微信支付宝订单号
     */
    private String channelTradeNo;
    /**
     * 订单完成时间，成功时返回，格式 yyyyMMddHHmmss
     */
    private String updateTime;
}