/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.trade;

import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.trade.XftUnifyChargeQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version XftUnifyChargeQueryRequest.java, v 0.1 2023-08-25 17:04 zhangling
 */
@Data
public class XftUnifyChargeQueryRequest extends XftBizRequest<XftUnifyChargeQueryResponse> {
    private static final long serialVersionUID = -280904163856036619L;

    /**
     * 商户号
     */
    @NotBlank
    private String merchantCode;
    /**
     * 商户订单号,d
     */
    @NotBlank
    private String outTradeNo;
    /**
     * 第三方支付订单号
     */
    private String thirdTradeNo;
    /**
     * 客户端调用的 IP
     */
    @NotBlank
    private String clientIp;
    /**
     * 特定渠道时需要的额外参数，详细参考 支付渠道 extra 参数说明 。
     */
    private String extra;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftUnifyChargeQueryResponse> getResponseClass() {
        return XftUnifyChargeQueryResponse.class;
    }
}