/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.trade;

import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.trade.XftUnifyChargePayResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhangling
 * @version XftUnifyChargePayRequest.java, v 0.1 2023-08-25 16:45 zhangling
 */
@Data
public class XftUnifyChargePayRequest extends XftBizRequest<XftUnifyChargePayResponse> {
    private static final long serialVersionUID = -5303024855405003772L;

    /**
     * 商户号
     */
    @NotBlank
    private String merchantCode;
    /**
     * 门店编号
     */
    private String storeCode;
    /**
     * 操作员 id
     */
    private String operatorId;
    /**
     * 00-全部 01-限定不能使 用信用卡支付 默认值 00
     */
    private String limitPay;
    /**
     * 商户订单号
     */
    @NotBlank
    private String outTradeNo;
    /**
     * 支付渠道,详细参考 支付渠道 channel 属性值
     */
    private String channel;
    /**
     * 支付产品,详细参考 支付产品 product 属性值，当支付类型为（微信，支付宝，银联）条码支付时非必传
     */
    private String product;
    /**
     * 客户端调用的 IP
     */
    @NotBlank
    private String clientIp;
    /**
     * 支付金额，单位分
     */
    @NotNull
    private Integer amount;
    /**
     * 订单标题，该参数最长 32 个 Unicode
     */
    @Length(max = 32, message = "subject长度不能超过32")
    private String subject;
    /**
     * 商品描述信息，该参数最长为 255 个 Unicode 字符
     */
    @Length(max =255, message = "body长度不能超过255")
    private String body;
    /**
     * 订单附加说明，最多 255 个 Unicode 字符
     */
    @Length(max =255, message = "description长度不能超过255")
    private String description;
    /**
     * 特定渠道发起交易时需要的额外参数，以及部分渠道支付成功返回的额外参数，详细参考 支付渠道 extra 参数说明
     */
    private String extra;
    /**
     * 交易的通知地址
     */
    private String notify_url;
    /**
     * 收银台支付成功回跳地址
     */
    private String callback_url;
    /**
     * 订单生成时间，格式为 yyyyMMddHHmmss。
     * 如 2009 年 12 月 25 日 9 点 10 分 10 秒表示为 20091225091010。
     * 时区为 GMT+8 beijing。该时间取自商户服务器。
     * 注：订单生成时间与超时时间需要同时传入才会生效
     */
    private String time_start;
    /**
     * 订单失效时间，格式为 yyyyMMddHHmmss。
     * 如 2009 年 12 月 27 日 9 点 10 分 10 秒表示为 20091227091010。
     * 时区为 GMT+8 beijing。该时间取自商户服务器。
     * 注：订单生成时间与超时时间需要同时传入才会生效。
     * 建议最短失效时间为 1 分钟
     */
    private String time_expire;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftUnifyChargePayResponse> getResponseClass() {
        return XftUnifyChargePayResponse.class;
    }
}