/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.xft.sdk.request.bill;

import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.bill.XftSettleBillDownloadQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version XftSettleBillDownloadQueryRequest.java, v 0.1 2023-08-25 17:17 zhangling
 */
@Data
public class XftSettleBillDownloadQueryRequest extends XftBizRequest<XftSettleBillDownloadQueryResponse> {
    private static final long serialVersionUID = -7291338151265034429L;

    /**
     * 统一平台商户编号
     */
    @NotBlank
    private String merchantCode;
    /**
     * 对账时间，格式 yyyyMMdd
     */
    @NotBlank
    private String billDate;
    /**
     * 对账类型，1-对账单
     */
    @NotBlank
    private String billType;


    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<XftSettleBillDownloadQueryResponse> getResponseClass() {
        return XftSettleBillDownloadQueryResponse.class;
    }
}