/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.xft.sdk.client;

import com.fshows.xft.sdk.client.impl.XftApiDefinition;
import com.fshows.xft.sdk.exception.XftPayException;
import com.fshows.xft.sdk.request.XftBizRequest;
import com.fshows.xft.sdk.response.XftBaseResponse;

/**
 * @author zhaoxumin
 * @version XftBaseClient.java, v 0.1 2023-08-25 下午10:35 zhaoxumin
 */
public interface XftBaseClient {
    /**
     * 请求星富通接口
     *
     * @param request          请求参数
     * @param xftApiDefinition 方法枚举
     * @param <R>              返参
     * @return UmBaseResponse
     * <p>
     * XftApiDefinition api方法请参考下列API枚举
     */
    <R> XftBaseResponse<R> execute(XftBizRequest<R> request, XftApiDefinition xftApiDefinition, String url) throws XftPayException;

    /**
     *
     * @param request
     * @param xftApiDefinition
     * @param url
     * @param subAppId
     * @return
     * @param <R>
     * @throws XftPayException
     */
    <R> XftBaseResponse<R> execute(XftBizRequest<R> request, XftApiDefinition xftApiDefinition, String url, String subAppId) throws XftPayException;

}
