/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import lombok.Data;

/**
 * @author Liluqing
 * @version PromotionDetailResponse.java, v 0.1 2020-04-28 14:52
 */
@Data
public class PromotionDetailResponse {

    /**
     * 券 id
     */
    private String promotionId;

    /**
     * 优惠来源； SXF:随行付, WX:微信, ZFB:支 付 宝 , UNION:银联
     */
    private String disSource;

    /**
     * 优惠名称
     */
    private String name;

    /**
     * 全范围； GLOBAL- 全场代金券 SINGLE- 单品优惠  DISCOUNT-折扣券
     */
    private String scope;

    /**
     * 优惠类型；COUPON-充值型代金券 DISCOUNT-免充值优惠券
     * SXF00001: 随行付随机立减
     */
    private String type;

    /**
     * 优惠总额；单位元，保留两位小数
     */
    private String amount;

    /**
     * 活动 id
     */
    private String activityId;

    /**
     * 平台出资（微信支付宝有银联）金额；单位元，保留两位小数
     */
    private String channelContribute;

    /**
     * 商户出资金额；单位元， 保留两位小数
     */
    private String merchantContribute;

    /**
     * 其他出资金额；单位元， 保留两位小数
     */
    private String otherContribute;

    /**
     * 随行付出资金额；单位元， 保留两位小数
     */
    private String sxfContribute;

    /**
     * 券备注信息
     */
    private String couponRemark;

    /**
     * 用户购买券实付金额
     */
    private String purBuyerContribute;
    /**
     * 用户购买券商户优惠金额
     */
    private String purMchContribute;
    /**
     * 用户购买券平台优惠金额
     */
    private String purPlatContribute;

    /**
     * 微信 subAppId
     */
    private String subAppid;


    /**
     * 单品优惠券列表(json 格式数组转字符串)
     */
    private String goodsDetail;
}