/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import lombok.Data;

import java.io.Serializable;

/**
 * @author mengqf
 * @version VbillUnionPidInfoRequest.java, v 0.1 2025-08-29 13:51 mengqf
 */
@Data
public class VbillUnionPidInfoRequest implements Serializable {
    private static final long serialVersionUID = 995813644297951877L;
    /**
     * 服务商订单编号
     * 服务商自定义并发送，同一交易日期内不可重复，订单编号将作为服务商和银联对账的唯一索引，不超过40字节的变长字母和/或数字字符，不能含“-”或“_”
     */
    private String pnrOrderId;
    /**
     * 服务商密文,由服务商根据服务商代码标识加密算法生成
     */
    private String pidSct;
    /**
     * 场景标识，取值如下：
     * 1-扫码点餐
     */
    private String tradeScene;
}