/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.TransferAccountsQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version TransferAccountsQueryRequest.java, v 0.1 2020-04-27 20:33
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TransferAccountsQueryRequest extends VbillBizRequest<TransferAccountsQueryResponse> {

    private static final long serialVersionUID = 1095595474578639271L;

    /**
     * 商户转账订单号
     */
    private String orderNo;

    /**
     * 天阙订单号
     */
    private String tranNo;

    /**
     * 转出商编
     */
    @NotBlank
    private String mno;

    @Override
    public Class<TransferAccountsQueryResponse> getResponseClass() {
        return TransferAccountsQueryResponse.class;
    }
}