/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantEditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wujn
 * @version MerchantIncomeRequest.java, v 0.1 2020-04-28 11:07 zhoujp
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantEditRequest extends VbillBizRequest<MerchantEditResponse> {
    private static final long serialVersionUID = 8877676625096482171L;
    /****************************** 基础参数 ******************************/
    /**
     * 随行付商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;

    /**
     * 签购单名称
     * <p>
     * 1、显示在消费者账单中的商户名称；
     * <p>
     * 2、建议填入实际经营的内容，如XX快餐店/XX炸鸡；
     * <p>
     * 3、最长20个字符，不能为纯数字。
     */
    private String merName;

    /**
     * 商户简称
     * 1、字母、数字、汉字都算 1 个字符，最长 20 个字符；
     * 2、显示给消费者看的商户名称，会显示支付页面中。建议填入实际经营的内容，如 XX快餐店/XX 炸鸡
     */
    @Length(max = 20, message = "商户简称超长")
    private String mecDisNm;
    /**
     * 商户联系手机号
     * 1、个人资质商户请传入在运营商实名认证过的商户负责人手机号
     * 2、企业资质商户传入企业联系人电话
     */
    private String mblNo;

    /**
     * 连锁分店是否独立结算
     * <p>
     * 取值范围：
     * <p>
     * 00 独立结算
     * <p>
     * 01 非独立结算
     * <p>
     * 当前商户类型(mecTypeFlag==02)连锁分店时可修改此参数；其他情况传入无效。
     */
    private String independentModel;

    /**
     * 注册地址省编码，长度12位
     * 需要与营业执照照面一致；
     * 注册地址省、市、区编码、街道地址（四个参数需同时上传），且营业执照信息更新必填01
     */
    private String provCd;

    /**
     * 注册地址市编码，长度12位
     * 需要与营业执照照面一致；
     * 注册地址省、市、区编码、街道地址（四个参数需同时上传），且营业执照信息更新必填01
     */
    private String cityCd;

    /**
     * 注册地址区编码，长度12位
     * 需要与营业执照照面一致；
     * 注册地址省、市、区编码、街道地址（四个参数需同时上传），且营业执照信息更新必填01
     */
    private String distCd;

    /**
     * 注册地址街道地址，最大长度128位
     * 直接填写详细街道门牌号即可；
     * 注册地址省、市、区编码、街道地址（四个参数需同时上传），且营业执照信息更新必填01
     */
    private String detailAddress;

    /**
     * 商户经营详细地址
     * 1、传入商户实际经营地信息
     * 2、详细地址无需填入省市区信息， 直接填写详细街道门牉号即可
     */
    private String cprRegAddr;
    /**
     * 商户经营地址省编码
     * 参见省市区代码表
     */
    private String regProvCd;
    /**
     * 商户经营地址市编码
     * 参见省市区代码表
     */
    private String regCityCd;
    /**
     * 商户经营地址区编码
     * 参见省市区代码表
     */
    private String regDistCd;

    /**
     * 经营类目，最大长度8位
     * 说明：
     * (1) 修改后的【mccCd经营类目】与现有【mccCd经营类目】不一致
     * (2) 修改后的【mccCd经营类目】与现有【mccCd经营类目】是相同费率通道的经营类目
     * (3) 商户的【operationalType经营类型】是01线下、02线上；或者商户的【operationalType经营类型】是03非盈利类，且商户的【repoInfo渠道报备信息】中支付宝子商户号报备失败
     */
    private String mccCd;

    /**
     * 客服电话
     * 数字，不能有 -
     */
    private String csTelNo;

    /**
     * 邮箱，长度30位
     * 此字段将上送至微信、支付宝
     */
    private String email;

    /****************************** 功能类信息 ******************************/
    /**
     * 回调地址，最大长度128位
     * 说明：天阙平台支持推送商户入驻审核的终态结果给该地址，推送格式参见接口
     */
    private String updateCallBackUrl;

    /**
     * 银行卡预授权开关，枚举值
     * 取值范围：
     * 01 关闭
     * 02 开通
     */
    private String bankCardPreAuthorization;

    /**
     * 二维码预授权开关，枚举值
     * 取值范围：
     * 01 关闭
     * 02 开通
     */
    private String qrCodePreAuthorization;

    /**
     * 复核回调地址，长度128位
     * 说明：传入则在商户信息修改状态为：【商户修改通过】时，返回复核标识及补充资料内容推送至该地址，推送格式参照接口TQM024
     * https://www.nify.com/nofy.htm
     */
    private String checkCallbackUrl;

    /****************************** 资质证照信息 ******************************/
    /**
     * 营业执照信息更新，枚举值
     * 取值范围：
     * 01 更新
     * 如【营业执照起始日】【营业执照到期日】【法人姓名】其中一项变更，可通过此参数触发调用鉴权，更新相关参数
     */
    private String isLicenseModify;

    /**
     * 营业执照起始日，长度8位
     * 格式为：YYYYMMDD
     * 营业执照起始日、营业执照到期日需同时上传
     */
    private String businessLicStt;

    /**
     * 营业执照到期日，长度8位
     * 格式为：YYYYMMDD
     * 营业执照起始日、营业执照到期日需同时上传
     * 长期有效请传29991231
     */
    private String businessLicEnt;

    /**
     * 法人姓名，长度128位
     * 法人信息变更时必传
     */
    private String identityName;

    /**
     * 法人证件类型，枚举值
     * <p>
     * 取值范围：
     * 00 身份证
     * 05 港澳居民往来内地通行证
     * 06 台湾居民来往大陆通行证
     * 07 护照
     * 99 其他
     */
    private String identityTyp;

    /**
     * 法人证件号，长度18位
     * 法人信息变更时必传
     */
    private String identityNo;

    /**
     * 法人/商户负责人证件起始日，长度8位
     * 格式为：YYYYMMDD
     */
    private String legalPersonLicStt;

    /**
     * 法人/商户负责人证件到期日，长度8位
     * 格式为：YYYYMMDD
     * 长期有效请传29991231
     */
    private String legalPersonLicEnt;

    /****************************** 结算账户信息 ******************************/

    /**
     * 结算账户名
     * 说明：
     * 1、对公结算时账户名需不注册名一致；
     * 2、自然人商户、线上类商户丌允许授权结算
     */
    private String actNm;
    /**
     * 结算账户类型
     * 自然人商户只允许对私结算
     * 线上商户只允许对公结算
     * 取值范围：00 对公 01 对私
     */
    private String actTyp;
    /**
     * 结算人证件号
     * 对私结算必传
     */
    private String stmManIdNo;

    /**
     * 结算人证件号起始日，长度8位
     * 格式为：YYYYMMDD
     */
    private String accountLicStt;

    /**
     * 结算人证件号到期日，长度8位
     * 格式为：YYYYMMDD
     * 长期有效请传29991231
     */
    private String accountLicEnt;

    /**
     * 结算卡号
     */
    private String actNo;

    /**
     * 开户银行，长度32位
     */
    private String depoBank;

    /**
     * 开户省份，长度12位
     */
    private String depoProvCd;

    /**
     * 开户城市，长度12位
     */
    private String depoCityCd;

    /**
     * 开户支行联行行号
     */
    private String lbnkNo;
    /**
     * 开户支行名称
     */
    private String lbnkNm;

    /****************************** 图片信息 ******************************/
    /**
     * 营业执照照片
     * 企业、个体户必传
     */
    private String licensePic;
    /**
     * 税务登记证照片
     * 企业非三证合一必传
     */
    private String taxRegistLicensePic;
    /**
     * 组织机构代码证
     * 企业非三证合一必传
     */
    private String orgCodePic;
    /**
     * 法人/商户负责人身份证正面（人像面）
     */
    private String legalPersonidPositivePic;
    /**
     * 法人/商户负责人身份证反面（国徽面）
     */
    private String legalPersonidOppositePic;
    /**
     * 开户许可证
     * 对公结算必传
     */
    private String openingAccountLicensePic;
    /**
     * 银行卡正面
     * 对私结算必传
     */
    private String bankCardPositivePic;
    /**
     * 银行卡反面
     */
    private String bankCardOppositePic;
    /**
     * 结算人身份证反面（国徽面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传
     */
    private String settlePersonIdcardOpposite;
    /**
     * 结算人身份证正面（人像面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传。
     */
    private String settlePersonIdcardPositive;
    /**
     * 商户协议照片
     */
    private String merchantAgreementPic;
    /**
     * 门头照片
     */
    private String storePic;
    /**
     * 真实商户内景图片
     */
    private String insideScenePic;
    /**
     * 经营场所-含收银台
     */
    private String businessPlacePic;
    /**
     * ICP 许可证或公众号主体信息截图
     * 线上网站类、公众号类商户必传
     */
    private String icpLicence;
    /**
     * 手持身份证（人像面）照片
     */
    private String handIdcardPic;

    /**
     * 新旧结算人手持身份证合照照片地址，长度32位
     */
    private String newAndOldHandIdCardPic;
    /**
     * 商户信息变更表
     */
    private String merchantInfoModifyPic;
    /**
     * 租赁协议三(签章页)
     */
    private String leaseAgreementThreePic;
    /**
     * 租赁协议二(面积、有效期页)
     */
    private String leaseAgreementTwoPic;
    /**
     * 租赁协议一(封面)
     */
    private String leaseAgreementOnePic;
    /**
     * 其他资料照片 1
     */
    private String otherMaterialPictureOne;
    /**
     * 其他资料照片 2
     */
    private String otherMaterialPictureTwo;
    /**
     * 其他资料照 3
     */
    private String otherMaterialPictureThree;
    /**
     * 其他资料照片 4
     */
    private String otherMaterialPictureFour;
    /**
     * 其他资料照 5
     */
    private String otherMaterialPictureFive;
    /**
     * 代理人签名
     */
    private String agentPersonSignature;
    /**
     * 确认人签名
     */
    private String confirmPersonSignature;
    /**
     * 非法人结算授权函（授权结算必传）
     * 非法人对私结算，即结算账户类型为对私结算，
     * 且结算人身份证号不法人身份证号丌一致时必传
     */
    private String letterOfAuthPic;
    /**
     * 统一结算无营业执照说明
     * 个人资质的连锁分店如果统一结算，需上传总店
     * 对该店情况说明，证明连锁关系
     */
    private String unionSettleWithoutLicense;
    /**
     * 社会团体法人证书
     */
    private String societyGroupLegPerPic;
    /**
     * 基金会法人登记证书
     */
    private String foundationLegPerRegPic;
    /**
     * 办学许可证
     */
    private String schoolLicese;
    /**
     * 医疗结构办学许可证
     */
    private String medicalInstitutionLicense;
    /**
     * 经营保险业务许可证
     */
    private String insuranceLicese;
    /**
     * 保险业务法人等级证书
     */
    private String insuranceLegPerGradePic;
    /**
     * 民办教育许可证
     */
    private String privateEducationLicense;
    /**
     * 收费证明文件
     */
    private String chargeProofPic;

    /**
     * 民办非企业单位登记证书，长度32位
     */
    private String privateNonEnterprisePic;

    /**
     * 收费样本文件，长度32位
     */
    private String feeSimplesPic;

    /**
     * 卫生局批文，长度32位
     */
    private String healthBureauApprovalPic;
    /**
     * 是否校验结算人三要素
     * 取值范围：00 校验 01不校验(默认为01)
     */
    private String settlementAuthen = "01";

    @Override
    public Class<MerchantEditResponse> getResponseClass() {
        return MerchantEditResponse.class;
    }
}