/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.merchant;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import com.fshows.vbill.sdk.response.merchant.item.AppConfigItem;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 微信子商户支付参数配置返回值
 *
 * @author buhao
 * @version MerchantWechatPaySetAddConfRequest.java, v 0.1 2020-06-12 11:20 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWechatPaySetQueryConfResponse extends VbillBizResponse {
    private static final long serialVersionUID = 8457532398464723482L;
    /**
     * 商编
     */
    private String mno;
    /**
     * 微信子商户号
     */
    private String subMchId;
    /**
     * 支付 Appid/关注 Appid
     */
    private List<AppConfigItem> appConfigList;
    /**
     * jsapi 授权目录
     */
    private List<String> jsapiPathList;
}