/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.merchant;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import com.fshows.vbill.sdk.response.merchant.item.QrcodeItem;
import com.fshows.vbill.sdk.response.merchant.item.RepoInfoItem;
import com.fshows.vbill.sdk.response.merchant.item.SpInfoItem;
import com.fshows.vbill.sdk.response.merchant.item.TerminalDevicesItem;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商户信息查询
 *
 * @author linzy
 * @version MerchantInfoQueryResponse.java, v 0.1 2021-10-11 10:55 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantInfoQueryResponse extends VbillBizResponse {
    private static final long serialVersionUID = -8280604071354735292L;
    /**
     * 商户简称
     */
    private String mecDisNm;
    /**
     * 商户联系手机号
     */
    private String mblNo;
    /**
     * 经营类型 01 线下 02 线上 03 非盈利类 04 缴
     * 费类 05 保险类 06 私立院校
     */
    private String operationalType;
    /**
     * 资质类型 01 自然人 02 个体户 03 企业
     */
    private String haveLicenseNo;
    /**
     * 商户类型 00 普通单店商户（非连锁商户）
     * 01 连锁总 02 连锁分 03 1+n 总 04 1+n分
     */
    private String mecTypeFlag;
    /**
     * 所属总店商户编号
     */
    private String parentMno;
    /**
     * 分店是否独立结算 00 是 01 否
     */
    private String independentModel;
    /**
     * 二维码费率（费率单位为%） json 返回
     */
    private List<QrcodeItem> qrcodeList;
    /**
     * 结算类型 03 T1 04 D1
     */
    private String settleType;
    /**
     * 支持的支付渠道 01 支付宝 02 微信 03 银联二维码
     */
    private String[] supportPayChannels;
    /**
     * 支持的交易类型 01 主扫 02 被扫 03 公众号/小程序/服务窗/银 联 JS 04 退货 05 APP
     */
    private String[] supportTradeTypes;
    /**
     * 终端信息，以 json 的形式返回
     * terminalNo：终端号
     * modelNo：设备型号
     * devicesName：设备名称
     */
    private List<TerminalDevicesItem> terminalDevicesInfo;
    /**
     * 线上产品类型 01 APP 02 网站 03 公众号
     */
    private String onlineType;
    /**
     * APP 名称/网站网址/公众号名称
     */
    private String onlineName;
    /**
     * APP 下载地址及账号信息
     */
    private String onlineTypeInfo;
    /**
     * 营业执照注册名称
     */
    private String cprRegNmCn;
    /**
     * 商户经营详细地址
     */
    private String cprRegAddr;
    /**
     * 商户经营地址省编码
     */
    private String regProvCd;
    /**
     * 商户经营地址市编码
     */
    private String regCityCd;
    /**
     * 商户经营地址区编码
     */
    private String regDistCd;
    /**
     * 经营类目
     */
    private String mccCd;
    /**
     * 客服电话
     */
    private String csTelNo;
    /**
     * 法人/商户负责人
     */
    private String identityName;
    /**
     * 结算账户名
     */
    private String actNm;
    /**
     * 结算账户类型 00 对公 01 对私
     */
    private String actTyp;
    /**
     * 结算人证件号
     */
    private String stmManIdNo;
    /**
     * 结算人证件号起始日
     */
    private String accountLicStt;
    /**
     * 结算人证件号到期日
     */
    private String accountLicEnt;
    /**
     * 结算卡号
     */
    private String actNo;
    /**
     * 开户支行联行行号
     */
    private String lbnkNo;
    /**
     * 开户支行名称
     */
    private String lbnkNm;

    /**
     * 渠道报备信息
     * 以json的形式返回
     * childNoType:WX微信,ZFB
     * 支付宝
     * repoStatus:01成功,02失败
     * channelId:接入方渠道号
     * childNo:渠道子商户号
     * errMessage:报备失败原因
     */
    private List<RepoInfoItem> repoInfo;
    /**
     * 收单机构商编
     */
    private List<SpInfoItem> spInfo;
}