/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillOrderCloseResponse;
import lombok.Data;

/**
 * @author Liluqing
 * @version OrderCloseParam.java, v 0.1 2020-04-23 20:46
 */
@Data
public class VbillOrderCloseRequest extends VbillBizRequest<VbillOrderCloseResponse> {

    /**
     * 随行付商编
     */
    private String mno;

    /**
     * 原交易商户订单号,64 个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String origOrderNo;

    /**
     * 原交易科技公司订单号
     */
    private String origUuid;

    @Override
    public Class<VbillOrderCloseResponse> getResponseClass() {
        return VbillOrderCloseResponse.class;
    }
}