/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantWechatPaySetAddConfResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author buhao
 * @version MerchantWechatPaySetAddConfRequest.java, v 0.1 2020-06-12 11:20 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWechatPaySetAddConfRequest extends VbillBizRequest<MerchantWechatPaySetAddConfResponse> {
    /**
     * 商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;
    @NotBlank(message = "subMchId不能为空")
    private String subMchId;
    /**
     * 配置类型
     * <p>
     * 取值范围：01 支付 Appid
     * <p>
     * 03 jsapi 授权目录
     */
    @NotBlank(message = "type不能为空")
    private String type;
    /**
     * 支付 Appid
     * <p>
     * 配置类型为 01，02 时必传
     */
    private String subAppid;
    /**
     * 推荐关注公众号 Appid
     * <p>
     * 配置类型为 02 时不推荐关注小程序 Appid 二选一
     */
    private String subscribeAppid;
    /**
     * 推荐关注小程序 Appid
     * <p>
     * 配置类型为 02 时不推荐关注公众号 Appid 二选一
     */
    private String receiptAppid;
    /**
     * jsapi 授权目录
     * <p>
     * 配置类型为 03 时必传
     */
    private String jsapiPath;

    /**
     * 支付Appid类型 配置类型为01(支付的appid)时必传 00公众号 01小程序 02APP
     */
    private String accountType;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantWechatPaySetAddConfResponse> getResponseClass() {
        return MerchantWechatPaySetAddConfResponse.class;
    }
}