/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantSetUpResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhoujp
 * @version MerchantSetUpRequest.java, v 0.1 2020-06-03 21:24 zhoujp
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSetUpRequest extends VbillBizRequest<MerchantSetUpResponse> {
    private static final long serialVersionUID = 3958062552095337591L;

    /**
     * 随行付商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;

    /**
     * 二维码费率（费率单位为%）
     * json 形式传入
     * 01 微信
     * 02 支付宝
     * 06 银联单笔小于等于 1000
     * 07 银联单笔大于 1000
     * 修改费率必须完整传入（同时包含微信、支付宝、银联二维码）
     * 例子：
     * "qrcodeList": [{"rate": "0.28","rateType": "01"},{"rate": "0.29","rateType": "02"},{"rate": "0.35","rateType": "06"},{"rate": "0.61","rateType": "07"}]
     */
    private ArrayList qrcodeList;

    /**
     * 结算类型
     * 取值范围：
     * 03 T1结算
     * 04 D1结算
     * 05 关闭自动结算产品
     */
    private String settleType;

    /**
     * balanceCashOut
     * 历史余额提现开关  01:关闭 02:开通
     */
    private String balanceCashOut;

    /**
     * 提现开关
     */
    private List<MerchantWithDrawalSwitchRequest> withDrawalSwitch;

    /**
     * reserveSettleAmt
     * 备用金
     */
    private String reserveSettleAmt;

    @Override
    public Class<MerchantSetUpResponse> getResponseClass() {
        return MerchantSetUpResponse.class;
    }
}