/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantInfoQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户进件状态查询
 *
 * @author buhao
 * @version MerchantIncomeQueryRequest.java, v 0.1 2020-06-08 11:05 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantInfoQueryRequest extends VbillBizRequest<MerchantInfoQueryResponse> {

    private static final long serialVersionUID = -7704983865606504384L;
    /**
     * 随行付商编
     */
    private String mno;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantInfoQueryResponse> getResponseClass() {
        return MerchantInfoQueryResponse.class;
    }
}