/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantIncomeQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户进件状态查询
 *
 * @author buhao
 * @version MerchantIncomeQueryRequest.java, v 0.1 2020-06-08 11:05 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIncomeQueryRequest extends VbillBizRequest<MerchantIncomeQueryResponse> {

    private static final long serialVersionUID = -4298021740116846104L;
    /**
     * 随行付商编
     */
    private String mno;
    /**
     * 进件申请 ID
     */
    private String applicationId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantIncomeQueryResponse> getResponseClass() {
        return MerchantIncomeQueryResponse.class;
    }
}