/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author wujn
 * @version PictureTypeEnum.java, v 0.1 2020-04-26 8:56 PM wujn
 */
public enum PictureTypeEnum {
    TAX_REGIST_LICENSE_PIC("01", "税务登记证"),
    CORPORATION_IDCARD_POSITIVE("02", "法人身份证人脸面"),
    CORPORATION_IDCARD_OPPOSITE("03", "法人身份证反面(国徽面)"),
    AOPEN_ACCOUNT_LICENSE("04", "开户许可证"),
    BANKCARD_POSITIVE_PIC("05", "银行卡正面"),
    BANKCARD_OPPOSITE_PIC("06", "银行卡反面"),
    IDCARD_BACK("07", "结算人身份证反面(国徽面)"),
    IDCARD_FACE("08", "结算人身份证正面(人像面)"),
    MERCHANT_AGREEMENT_PIC("09", "商户协议照片"),
    STORE_PIC("10", "门头照"),
    INSIDESCENE_PIC("11", "内景照"),
    BUSINESS_PLACE_PIC("12", "收银台照"),
    LICENSE_PIC("13", "营业执照"),
    ORG_CODE_PIC("14", "组织机构代码证"),
    HAND_IDCARD_PIC("15", "手持身份证(人像面)照片"),
    LEASE_AGREEMENT_ONE_PIC("16", "租赁协议一(封面)"),
    LEASE_AGREEMENT_TWO_PIC("17", "租赁协议二(面积、有效期页)"),
    LEASE_AGREEMENT_THREE_PIC("18", "租赁协议三(签章页)"),
    OTHER_MATERIAL_PICTURE_ONE("19", "其他资料照片(1)"),
    OTHER_MATERIAL_PICTURE_TWO("20", "其他资料照片(2)"),
    OTHER_MATERIAL_PICTURE_THREE("21", "其他资料照片(3)"),
    OTHER_MATERIAL_PICTURE_FOUR("22", "其他资料照片(4)"),
    OTHER_MATERIAL_PICTURE_FIVE("23", "其他资料照片(5)"),
    AGENT_PERSON_SIGNATURE("24", "代理人签名"),
    CONFIRM_PERSON_SIGNATURE("25", "确认人签名"),
    LETTER_OF_AUTH_PIC("26", "非法人结算授权函"),
    UNION_SETTLE_WITHOUT_LICENSE("27", "统一结算无营业执照说明"),
    MERCHANT_AGREEMENT("28", "商家入驻协议"),
    ICP_LICENCE("29", "ICP 许可证或公众号主体信息截图"),
    NEW_AND_OLD_HAND_IDCARD_PIC("30", "新旧结算人手持身份证 (人像面)合照"),
    MERCHANT_INFO_MODIFY_PIC("31", "商户信息变更表"),
    SOCIETY_GROUP_LEG_PER_PIC("32", "社会团体法人证书"),
    FOUNDATION_LEG_PER_REG_PIC("33", "基金会法人登记证书"),
    SCHOOLL_ICENSE("34", "办学许可证"),
    MEDICAL_INSTITUTION_LICENSE("35", "医疗机构办学许可证"),
    INSURANCE_LICENSE("36", "经营保险业务许可证"),
    INSURANCE_LEG_PER_GRADE_PIC("37", "保险业务法人等级证书"),
    PRIVATE_EDUCATION_LICENSE("38", "民办教育许可证"),
    CHARGE_PROOF_PIC("39", "收费证明文件)");

    private String code;
    private String desc;

    PictureTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PictureTypeEnum getByCode(String code) {
        PictureTypeEnum[] valueList = PictureTypeEnum.values();
        for (PictureTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getCode(), code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */

    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */

    public String getDesc() {
        return desc;
    }
}
