/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.vbill.sdk.client;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.vbill.sdk.exception.VbillApiException;
import com.fshows.vbill.sdk.request.common.UploadPictureRequest;
import com.fshows.vbill.sdk.response.BaseVbillResponse;
import com.fshows.vbill.sdk.response.common.UploadPictureReponse;
import com.fshows.vbill.sdk.util.ReqIdUtil;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadPictureClient {
    private static final Logger log = LoggerFactory.getLogger(UploadPictureClient.class);

    public BaseVbillResponse upload(UploadPictureRequest request) throws VbillApiException {
        long beginTime = System.currentTimeMillis();
        log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u5f00\u59cb reqId={},url={},request={},begin={}", new Object[]{request.getReqId(), request.getUploadUrl(), request, beginTime});
        String uploadUrl = request.getUploadUrl();
        String downloadUrl = request.getDownloadUrl();
        if (StringUtils.isBlank((CharSequence)uploadUrl) || StringUtils.isBlank((CharSequence)downloadUrl)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u548c\u4e0b\u8f7d\u5730\u5740\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String filePath = new URI(downloadUrl).getPath();
            String fileSuffix = StringUtils.substring((String)filePath, (int)filePath.lastIndexOf("."));
            if (".jpeg".equalsIgnoreCase(fileSuffix)) {
                fileSuffix = ".jpg";
            }
            String fileName = ReqIdUtil.getId() + fileSuffix;
            HttpResponse httpResponse = HttpRequest.get((String)downloadUrl).executeAsync();
            if (!httpResponse.isOk()) {
                throw new HttpException("Server response error with status code: [{}]", new Object[]{httpResponse.getStatus()});
            }
            Integer timeout = request.getTimeout() == null || request.getTimeout() <= 0 ? 30000 : request.getTimeout();
            String responseStr = HttpUtil.createPost((String)uploadUrl).form("file", httpResponse.bodyBytes(), fileName).form("reqId", (Object)request.getReqId()).form("orgId", (Object)request.getOrgId()).form("pictureType", (Object)request.getPictureType()).timeout(timeout.intValue()).execute().body();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            BaseVbillResponse<UploadPictureReponse> response = new BaseVbillResponse<UploadPictureReponse>();
            response.setReqId(jsonObject.getString("reqId"));
            response.setMsg(jsonObject.getString("msg"));
            response.setCode(jsonObject.getString("code"));
            response.setOrgId(jsonObject.getString("orgId"));
            UploadPictureReponse respData = (UploadPictureReponse)JSON.parseObject((String)jsonObject.getString("respData"), UploadPictureReponse.class);
            response.setRespData(respData);
            log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u7ed3\u675f reqId={},url={},request={},response={},cost={} ms", new Object[]{request.getReqId(), uploadUrl, request, response, System.currentTimeMillis() - beginTime});
            return response;
        }
        catch (Exception ex) {
            throw new VbillApiException(ex.getMessage(), ex);
        }
    }
}

