/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.merchant;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户修改查询结果
 *
 * @author buhao
 * @version MerchantChangeQueryResponse.java, v 0.1 2020-06-08 11:23 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantChangeQueryResponse extends VbillBizResponse {
    private static final long serialVersionUID = -7608468663350365230L;
    /**
     * 进件申请ID
     */
    private String applicationId;
    /**
     * 商编
     */
    private String mno;
    /**
     * 审核状态
     * 4 商户修改审核中
     * 5 商户修改通过
     * 6 商户修改驳回
     */
    private Integer taskStatus;
    /**
     * 审核信息，驳回原因
     */
    private String suggestion;
}