/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillScanCardResponse;
import lombok.Data;

/**
 * 刷卡入参
 *
 * @author Liluqing
 * @version ScanCardParam.java, v 0.1 2020-04-22 11:56
 */
@Data
public class VbillScanCardRequest extends VbillBizRequest<VbillScanCardResponse> {

    /**
     * 随行付商编
     */
    private String mno;
    /**
     * 子商户号
     */
    private String subMechId;

    /**
     * 微信 subAppId
     */
    private String subAppid;

    /**
     * 商户订单号,64个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String ordNo;

    /**
     * 授权码通过扫码枪/声波获取设备获取
     */
    private String authCode;

    /**
     * 订单总金额，单位为元，精确到小数点后两位，取值范围
     * <p>
     * [0.01,100000000]
     */
    private String amt;

    /**
     * 参与优惠金额，单位元，精确到小数点后两位[0.01,100000000]；
     * 支付宝专用
     */
    private String discountAmt;

    /**
     * 不参与优惠金额，单位元，精确到小数点后两位[0.01,100000000]；
     * 支付宝专用
     */
    private String unDiscountAmt;

    /**
     * 支付渠道，对订单的描述，取值范围：WECHAT:微 信,ALIPAY:支付宝，UNIONPAY:银联
     */
    private String payType;

    /**
     * 支付场景，1：刷卡 2：声波3：刷脸不上传默认为 1
     */
    private String scene;

    /**
     * 订单标题
     */
    private String subject;

    /**
     * 交易来源；
     * 01：服务商
     * 02：收银台
     * 03：硬件
     */
    private String tradeSource;

    /**
     * 交易 ip 地址
     */
    private String trmIp;

    /**
     * 限制卡类型
     * 00-全部
     * 01-限定不能使用信用卡支付
     * 默认值 00
     */
    private String limitPay;

    /**
     * 花呗分期数
     */
    private String hbFqNum;

    /**
     * 卖家承担分期服务费比例；不上送默认由买家承担
     */
    private String hbFqPercent;

    /**
     * 订单优惠标识
     * 00：是，01：否；目前仅支持微信；交易渠道为支付宝、银联时上送该参数则返回错误
     */
    private String goodsTag;

    /**
     * 微信优惠参数
     */
    private String wxGoodsTag;

    /**
     * 优惠详情信息(json 格式，里面内容见下面说明)
     */
    private String couponDetail;

    /**
     * 电子发票功能微信开具电子发票使用；目前仅支持微信；
     * 交易渠道为支付宝、银联时上送该参数则返回错00:是，01:否
     */
    private String needReceipt;

    /**
     * 是否做分账分账交易使用；00：做；01：不做；不传默认为不做分账
     */
    private String ledgerAccountFlag;

    /**
     * 分账有效时间单位为天；
     * 是否做分账选择00 时该字段必传；
     * 最大支持上送：
     * 30 ；注：从发起交易日期记为 1
     */
    private String ledgerAccountEffectTime;

    /**
     * 支付结果通知地址
     */
    private String notifyUrl;

    /**
     * 银联终端号
     */
    private String ylTrmNo;

    /**
     * TQ 机具编号，支付来源为硬件时，该参数为必传；
     */
    private String terminalId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 是否实名支付：00：是，01：否 不传默认为 01;00 时；买家姓名、证件类型、证件号为必填
     */
    private String identityFlag;

    /**
     * 证件类型 : 大陆 ： IDCARD ；目前仅支持大陆证件号
     */
    private String buyerIdType;

    /**
     * 证件号:证件号只允许等于 18位
     */
    private String buyerIdNo;

    /**
     * 买家姓名
     */
    private String buyerName;

    /**
     * 手机号
     */
    private String mobileNum;

    /**
     * 备用
     */
    private String extend;

    /**
     * 蚂蚁门店编号
     * 支付宝未来校园活动必传
     */
    private String alipayStoreId;

    /**
     * 随行付门店编号，长度32位
     */
    private String storeNum;

    /**
     * 门店编号，长度32位
     * 对应支付宝store_id
     */
    private String storeId;


    /**
     * 支付宝校园场景ID
     */
    private String eduSchoolId;

    /**
     * 支付宝校园场景ID
     */
    private String eduScene;
    
    /**
    * 支付宝业务拓展字段
    */
    private String zfbBusinessParams;

    /**
     * 分期数
     */
    private String fqNum;

    /**
     * 商家承担手续费比例
     */
    private String fqSellerPercent;

    /**
     * 分期渠道
     */
    private String fqChannels;

    @Override
    public Class getResponseClass() {
        return VbillScanCardResponse.class;
    }
}