/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillOrderCancelResponse;
import lombok.Data;

/**
 * 订单撤销入参
 *
 * @author Liluqing
 * @version OrderCancelParam.java, v 0.1 2020-04-23 20:37
 */
@Data
public class VbillOrderCancelRequest extends VbillBizRequest<VbillOrderCancelResponse> {

    /**
     * 随行付商编
     */
    private String mno;

    /**
     * 原交易商户订单号,64 个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String origOrderNo;

    /**
     * 原交易科技公司订单号
     */
    private String origUuid;


    @Override
    public Class<VbillOrderCancelResponse> getResponseClass() {
        return VbillOrderCancelResponse.class;
    }
}