/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.WxOpenidResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version WxOpenidParam.java, v 0.1 2020-04-22 15:58
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxOpenidRequest extends VbillBizRequest<WxOpenidResponse> {

    private static final long serialVersionUID = 8004134514522531687L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 微信子商户号
     */
    @NotBlank
    private String subMchId;

    /**
     * 关联公众号
     */
    @NotBlank
    private String subAppId;

    /**
     * 授权码
     */
    @NotBlank
    private String authCode;

    @Override
    public Class<WxOpenidResponse> getResponseClass() {
        return WxOpenidResponse.class;
    }
}