/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantIncomeEditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author wujn
 * @version MerchantIncomeEditRequest.java, v 0.1 2020-06-05 8:59 AM wujn
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIncomeEditRequest extends VbillBizRequest<MerchantIncomeEditResponse> {
    private static final long serialVersionUID = -6253619379833511871L;

    /**
     * 随行付商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;
    /**
     * 商户简称
     * 1、字母、数字、汉字都算 1 个字符，最长 20 个字符；
     * 2、显示给消费者看的商户名称，会显示支付页面中。建议填入实际经营的内容，如 XX快餐店/XX 炸鸡
     */
    private String mecDisNm;
    /**
     * 商户联系手机号
     * 1、个人资质商户请传入在运营商实名认证过的商户负责人手机号
     * 2、企业资质商户传入企业联系人电话
     */
    private String mblNo;
    /**
     * 商户类型
     * 取值范围： 00 普通单店商户（非连锁商户）01 连锁总 02 连锁分 03 1+n 总 04 1+n 分
     * 说明：
     * （1）非连锁商户直接传入 00 即可。
     * （2）连锁总店、1+N 总店请传入 01、03，请勿当做普通商户进件。
     * （3）连锁总店、1+n 总店丌支持自然人进件
     * （4）1+n 分店丌支持企业资质商户。
     */
    private String mecTypeFlag;
    /**
     * 商户经营详细地址
     * 1、传入商户实际经营地信息
     * 2、详细地址无需填入省市区信息， 直接填写详细街道门牉号即可
     */
    private String cprRegAddr;
    /**
     * 商户经营地址省编码
     * 参见省市区代码表
     */
    private String regProvCd;
    /**
     * 商户经营地址市编码
     * 参见省市区代码表
     */
    private String regCityCd;
    /**
     * 商户经营地址区编码
     * 参见省市区代码表
     */
    private String regDistCd;
    /**
     * 经营类目
     * 参见类目 ID 附件
     * 注意：商户入网时请选择正确 MCC 入网。对于需要报名 AT 活劢（蓝海/微信智慧餐饮/微信高校食堂）的商户，请按照上游要求的 MCC 进件，
     * 否则会导致后期报名 AT 活劢失败。MCC 要求详见 AT 活劢报名接口文档。
     */
    private String mccCd;
    /**
     * 客服电话
     * 数字，不能有 -
     */
    private String csTelNo;
    /**
     * 结算卡号
     */
    private String actNo;
    /**
     * 开户支行联行行号
     */
    private String lbnkNo;
    /**
     * 开户支行名称
     */
    private String lbnkNm;
    /**
     * 营业执照照片
     * 企业、个体户必传
     */
    private String licensePic;
    /**
     * 税务登记证照片
     * 企业非三证合一必传
     */
    private String taxRegistLicensePic;
    /**
     * 组织机构代码证
     * 企业非三证合一必传
     */
    private String orgCodePic;
    /**
     * 法人/商户负责人身份证正面（人像面）
     */
    private String legalPersonidPositivePic;
    /**
     * 法人/商户负责人身份证反面（国徽面）
     */
    private String legalPersonidOppositePic;
    /**
     * 开户许可证
     * 对公结算必传
     */
    private String openingAccountLicensePic;
    /**
     * 银行卡正面
     * 对私结算必传
     */
    private String bankCardPositivePic;
    /**
     * 银行卡反面
     */
    private String bankCardOppositePic;
    /**
     * 结算人身份证反面（国徽面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传
     */
    private String settlePersonIdcardOpposite;
    /**
     * 结算人身份证正面（人像面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传。
     */
    private String settlePersonIdcardPositive;
    /**
     * 商户协议照片
     */
    private String merchantAgreementPic;
    /**
     * 门头照片
     */
    private String storePic;
    /**
     * 真实商户内景图片
     */
    private String insideScenePic;
    /**
     * 经营场所-含收银台
     */
    private String businessPlacePic;
    /**
     * ICP 许可证或公众号主体信息截图
     * 线上网站类、公众号类商户必传
     */
    private String icpLicence;
    /**
     * 手持身份证（人像面）照片
     */
    private String handIdcardPic;
    /**
     * 租赁协议三(签章页)
     */
    private String leaseAgreementThreePic;
    /**
     * 租赁协议二(面积、有效期页)
     */
    private String leaseAgreementTwoPic;
    /**
     * 租赁协议一(封面)
     */
    private String leaseAgreementOnePic;
    /**
     * 其他资料照片 1
     */
    private String otherMaterialPictureOne;
    /**
     * 其他资料照片 2
     */
    private String otherMaterialPictureTwo;
    /**
     * 其他资料照 3
     */
    private String otherMaterialPictureThree;
    /**
     * 其他资料照片 4
     */
    private String otherMaterialPictureFour;
    /**
     * 其他资料照 5
     */
    private String otherMaterialPictureFive;
    /**
     * 代理人签名
     */
    private String agentPersonSignature;
    /**
     * 确认人签名
     */
    private String confirmPersonSignature;
    /**
     * 非法人结算授权函（授权结算必传）
     * 非法人对私结算，即结算账户类型为对私结算，
     * 且结算人身份证号不法人身份证号丌一致时必传
     */
    private String letterOfAuthPic;
    /**
     * 统一结算无营业执照说明
     * 个人资质的连锁分店如果统一结算，需上传总店
     * 对该店情况说明，证明连锁关系
     */
    private String unionSettleWithoutLicense;
    /**
     * 社会团体法人证书
     */
    private String societyGroupLegPerPic;
    /**
     * 基金会法人登记证书
     */
    private String foundationLegPerRegPic;
    /**
     * 办学许可证
     */
    private String schoolLicese;
    /**
     * 医疗结构办学许可证
     */
    private String medicalInstitutionLicense;
    /**
     * 经营保险业务许可证
     */
    private String insuranceLicese;
    /**
     * 保险业务法人等级证书
     */
    private String insuranceLegPerGradePic;
    /**
     * 民办教育许可证
     */
    private String privateEducationLicense;
    /**
     * 收费证明文件
     */
    private String chargeProofPic;
    /**
     * 是否校验结算人三要素
     * 取值范围：00 校验 01不校验(默认为01)
     */
    private String settlementAuthen = "01";

    @Override
    public Class<MerchantIncomeEditResponse> getResponseClass() {
        return MerchantIncomeEditResponse.class;
    }
}
