/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.WechatFaceAuthInfoResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version WechatFaceAuthInfoRequest.java, v 0.1 2020-04-27 16:43
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WechatFaceAuthInfoRequest extends VbillBizRequest<WechatFaceAuthInfoResponse> {

    private static final long serialVersionUID = 38771501741621481L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 门店编号
     */
    @NotBlank
    private String storeNo;

    /**
     * 订单号
     */
    @NotBlank
    private String orderNo;

    /**
     * 初始数据
     */
    @NotBlank
    private String rawdata;

    /**
     * 微信终端编号仅支持上送32位(WXtrmno)
     */
    @NotBlank
    private String deviceId;

    /**
     * 微信子商户号
     */
    private String subMchId;

    /**
     * 公众号id
     */
    private String subAppId;

    /**
     * 附加参数
     */
    private String attach;

    @Override
    public Class<WechatFaceAuthInfoResponse> getResponseClass() {
        return WechatFaceAuthInfoResponse.class;
    }
}